/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;

public class ShulkerBoxBlock
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.f_52588_;
    private static final VoxelShape ITEM_ENTITY_COLLISION_SHAPE = ShulkerBoxBlock.m_49796_((double)0.1, (double)0.1, (double)0.1, (double)15.9, (double)15.9, (double)15.9);

    public ShulkerBoxBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(ShulkerBoxBlock.getProperties(), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    private static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.StatePredicate statePredicate = (state, blockGetter, pos) -> {
            BlockEntity blockentity = blockGetter.m_7702_(pos);
            if (!(blockentity instanceof ShulkerBoxBlockEntity)) {
                return true;
            }
            ShulkerBoxBlockEntity shulkerboxblockentity = (ShulkerBoxBlockEntity)blockentity;
            return shulkerboxblockentity.isClosed();
        };
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76319_).m_60978_(2.0f).m_60988_().m_60955_().m_60960_(statePredicate).m_60971_(statePredicate);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ShulkerBoxBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get(), (l, pos, s, blockEntity) -> {
            ShulkerBoxBlockEntity.tick(l, pos, s, blockEntity);
            if (!l.f_46443_) {
                StorageBlockEntity.serverTick(l, pos, blockEntity);
            }
        });
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ShulkerBoxBlockEntity) || !ShulkerBoxBlock.canOpen(state, level, pos, shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity)) {
            return InteractionResult.PASS;
        }
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(b -> {
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12970_));
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(StorageBlockEntity::getDisplayName).orElse(TextComponent.f_131282_)), (BlockPos)pos);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        });
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> {
            Item patt5868$temp;
            NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.m_142466_(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
            if ((patt5868$temp = stack.m_41720_()) instanceof ShulkerBoxItem) {
                ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)patt5868$temp;
                StorageWrapper storageWrapper = be.getStorageWrapper();
                shulkerBoxItem.getMainColor(stack).ifPresent(storageWrapper::setMainColor);
                shulkerBoxItem.getAccentColor(stack).ifPresent(storageWrapper::setAccentColor);
                InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
                UpgradeHandler upgradeHandler = storageWrapper.getUpgradeHandler();
                storageWrapper.increaseSize(shulkerBoxItem.getNumberOfInventorySlots(stack) - inventoryHandler.getSlots(), shulkerBoxItem.getNumberOfUpgradeSlots(stack) - upgradeHandler.getSlots());
            }
            be.tryToAddToController();
            be.m_6596_();
        });
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((ItemLike)this));
        for (DyeColor color : DyeColor.values()) {
            ItemStack storageStack = this.getTintedStack(color);
            items.add((Object)storageStack);
        }
        ItemStack storageStack = new ItemStack((ItemLike)this);
        Item item = storageStack.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])DyeColor.YELLOW.m_41068_()));
            tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])DyeColor.LIME.m_41068_()));
        }
        items.add((Object)storageStack);
    }

    public ItemStack getTintedStack(DyeColor color) {
        ItemStack storageStack = new ItemStack((ItemLike)this);
        Item item = storageStack.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.m_41068_()));
            tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.m_41068_()));
        }
        return storageStack;
    }

    private static boolean canOpen(BlockState state, Level level, BlockPos pos, ShulkerBoxBlockEntity blockEntity) {
        if (blockEntity.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.m_149793_((Direction)((Direction)state.m_61143_(FACING)), (float)0.0f, (float)0.5f).m_82338_(pos).m_82406_(1.0E-6);
        return level.m_45772_(aabb);
    }

    @Override
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockentity;
            if (!level.f_46443_ && player.m_7500_()) {
                ItemStack shulkerBoxDrop = new ItemStack((ItemLike)this);
                this.addShulkerContentsToStack(shulkerBoxDrop, shulkerBoxBlockEntity);
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, shulkerBoxDrop);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        this.addShulkerContentsToStack(stack, be);
    }

    private void addShulkerContentsToStack(ItemStack stack, StorageBlockEntity be) {
        StorageWrapper storageWrapper = be.getStorageWrapper();
        UUID shulkerBoxUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
        CompoundTag shulkerContents = be.m_187482_();
        shulkerContents.m_128473_("controllerPos");
        if (!shulkerContents.m_128456_()) {
            ItemContentsStorage.get().setStorageContents(shulkerBoxUuid, shulkerContents);
            NBTHelper.setUniqueId((ItemStack)stack, (String)"uuid", (UUID)shulkerBoxUuid);
        }
        this.addBasicPropertiesToStack(stack, be, storageWrapper);
    }

    private void addBasicPropertiesToStack(ItemStack stack, StorageBlockEntity be, StorageWrapper storageWrapper) {
        be.getCustomName().ifPresent(arg_0 -> ((ItemStack)stack).m_41714_(arg_0));
        Item item = stack.m_41720_();
        if (item instanceof ShulkerBoxItem) {
            int accentColor;
            ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)item;
            int mainColor = storageWrapper.getMainColor();
            if (mainColor > -1) {
                shulkerBoxItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = storageWrapper.getAccentColor()) > -1) {
                shulkerBoxItem.setAccentColor(stack, accentColor);
            }
            shulkerBoxItem.setNumberOfInventorySlots(stack, storageWrapper.getInventoryHandler().getSlots());
            shulkerBoxItem.setNumberOfUpgradeSlots(stack, storageWrapper.getUpgradeHandler().getSlots());
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockentity;
            voxelShape = Shapes.m_83064_((AABB)shulkerBoxBlockEntity.getBoundingBox(state));
        } else {
            voxelShape = Shapes.m_83144_();
        }
        return voxelShape;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ShulkerBoxBlockEntity.class).ifPresent(be -> {
            StorageWrapper storageWrapper = be.getStorageWrapper();
            this.addBasicPropertiesToStack(stack, (StorageBlockEntity)((Object)be), storageWrapper);
        });
        return stack;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }

    @Override
    public void setTicking(Level level, BlockPos pos, BlockState currentState, boolean ticking) {
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShulkerBoxBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_(FACING);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        return context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() instanceof ItemEntity ? ITEM_ENTITY_COLLISION_SHAPE : super.m_5939_(state, level, pos, context);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }
}

